"use client";

import { Menu } from "lucide-react";
import { useState } from "react";
import { Sidebar } from "./Sidebar";
import Link from "next/link";
import { useLocale } from "next-intl";
import { NavMenu } from "./Navitems";
import Image from "next/image";
import { PrimaryButton } from "@/components";

export const navLinks = [
  { link: "/", title: "Home", children: [] },
  { link: "/about", title: "About Us", children: [] },
  {
    link: "/services",
    title: "Services",
    children: [
      { link: "/services/ship-management", title: "Ship Management" },
      { link: "/services/crewing", title: "Crewing" },
      { link: "/services/ship-supplies", title: "Ship Supplies" },
      { link: "/services/maintenance", title: "Maintenance & Scheduling" },
      { link: "/services/dry-dock", title: "Dry Dock Coordination" },
      { link: "/services/fleet-overview", title: "Fleet Overview" },
    ],
  },
  { link: "/fleet", title: "Fleet", children: [] },
  { link: "/contact", title: "Contact", children: [] },
];

export const socialLinks = [
  {
    icon: "/images/icons/x-white.svg",
    href: "https://www.x.com",
    ariaLabel: "Go to x account",
  },
  {
    icon: "/images/icons/facebook-white.svg",
    href: "https://www.facebook.com",
    ariaLabel: "Go to facebook account",
  },
  {
    icon: "/images/icons/instagram-white.svg",
    href: "https://www.instagram.com",
    ariaLabel: "Go to instagram account",
  },
  {
    icon: "/images/icons/linkedin-white.svg",
    href: "https://www.linkedin.com",
    ariaLabel: "Go to linkedin account",
  },
];

export const Navbar = () => {
  const [sidebarOpen, setSidebarOpen] = useState(false);

  const locale = useLocale();

  return (
    <header className="absolute inset-0 z-50 px-10 md:px-16 xl:px-28 min-[1600px]:px-40 w-full h-fit">
      <nav className="relative flex items-center justify-between pt-8 lg:pt-16 pb-5 z-50">
        <div className="w-full flex justify-between items-center gap-3 lg:hidden">
          <div className="flex items-center gap-2">
            <Image
              src={"/images/logo-white.png"}
              alt="logo"
              width={75}
              height={68}
              quality={100}
            />
          </div>
          <div className="flex items-center">
            <button onClick={() => setSidebarOpen(true)}>
              <Menu className="size-5 text-white cursor-pointer" />
            </button>
          </div>
        </div>

        <NavMenu data={navLinks} variant="desktop" locale={locale} />

        {/* Logo */}
        <Link href={`/${locale}`} className="hidden lg:flex items-center gap-2">
          <Image
            src={"/images/logo-white.png"}
            alt="logo"
            width={75}
            height={68}
          />
        </Link>

        <div className="flex items-center gap-10 max-lg:hidden">
          <div className="flex items-center gap-3">
            {socialLinks?.map((link, index) => (
              <a href={link?.href} key={index}>
                <Image
                  src={link?.icon}
                  alt={link?.ariaLabel}
                  width={16}
                  height={16}
                />
              </a>
            ))}
          </div>

          <PrimaryButton text="Book an Appointment" />
        </div>
      </nav>

      {/* Custom Sidebar */}
      <Sidebar
        isOpen={sidebarOpen}
        onClose={() => setSidebarOpen(false)}
        menuData={navLinks}
      />
    </header>
  );
};
