"use client";

import Image from "next/image";

export const FleetPage = () => {
  const vessels = [
    { name: "MOONLIT", imo: "IMO 9293882" },
    { name: "AG VALIANT", imo: "IMO 9173018" },
    { name: "CORELIT", imo: "IMO 9573799" },
    { name: "FORTUNELIT", imo: "IMO 9631694" },
    { name: "GLIMLIT", imo: "IMO 9589736" },
    { name: "HASONOLIT", imo: "IMO 9498928" },
  ];

  const approvedClasses = ["DNV", "NK", "RINA"];

  const flags = ["Barbados", "Palau", "Saint Vincent and the Grenadines"];

  return (
    <div className="bg-bodyBg">
      {/* Hero */}
      <section className="relative m-6 mb-10 rounded-2xl overflow-hidden h-[260px] md:h-[360px] lg:h-[420px]">
        <Image
          src="/images/fleet-hero.jpg"
          alt="Our Fleet"
          fill
          priority
          className="object-cover"
        />
        <div className="absolute inset-0 bg-black/40" />

        <div className="relative z-10 h-full flex flex-col justify-center items-center text-center text-white px-4">
          <p className="captionText mb-2">Home  b7 Our Fleet</p>
          <h1 className="h1Text">Our Fleet</h1>
        </div>
      </section>

      <section className="custom-container flex flex-col gap-12 pb-16">
        {/* Our Fleet + vessels list */}
        <div className="grid lg:grid-cols-[minmax(0,1.1fr)_minmax(0,1.2fr)] gap-10 items-start">
          <div className="space-y-4">
            <h2 className="h3Text text-primary">Our Fleet</h2>
            <div className="h-px w-16 bg-secondary" />
            <p className="h4Text text-primaryText">
              Managing a modern fleet operating under international class
              standards.
            </p>
            <p className="bodyText text-thirdText leading-relaxed max-w-xl">
              Hellenic Glamor Ship Management L.L.C currently manages a total of
              6 vessels, operating under approved class societies and
              international maritime regulations.
            </p>
          </div>

          <div className="grid sm:grid-cols-2 gap-4">
            {vessels.map((vessel) => (
              <div
                key={vessel.name}
                className="flex items-center gap-3 rounded-2xl bg-secondary/10 border border-secondary/30 px-4 py-4"
              >
                <div className="flex items-center justify-center rounded-xl bg-primary text-white p-2">
                  <Image
                    src="/images/icons/ship-dark.svg"
                    alt="ship icon"
                    width={28}
                    height={28}
                  />
                </div>
                <div className="flex flex-col">
                  <span className="h6Text text-primaryText">{vessel.name}</span>
                  <span className="smallText text-thirdText">{vessel.imo}</span>
                </div>
              </div>
            ))}
          </div>
        </div>

        {/* Management Approach */}
        <section className="rounded-3xl bg-primary text-secondaryText px-6 py-10 md:px-10 md:py-12 flex flex-col lg:flex-row gap-8 items-center">
          <div className="flex-1 space-y-4">
            <h3 className="h3Text">Management Approach</h3>
            <div className="h-px w-16 bg-secondary" />
            <p className="bodyText text-secondaryText/90 leading-relaxed">
              Our fleet is managed through a structured framework covering ship
              management, crewing, supplies, maintenance, scheduling, and
              dry-dock coordination. Every vessel is monitored for operational
              readiness, compliance, safety, and performance, ensuring owners
              receive consistent updates and reliable, transparent oversight.
            </p>
          </div>

          <div className="flex-1 w-full max-w-sm">
            <div className="relative rounded-3xl overflow-hidden min-h-[220px] md:min-h-[260px]">
              <Image
                src="/images/fleet-management.jpg"
                alt="Fleet management team"
                fill
                className="object-cover"
              />
            </div>
          </div>
        </section>

        {/* Approved Classes & Flags */}
        <section className="rounded-3xl bg-mainBg shadow-sm border border-secondary/20 px-6 py-10 md:px-10 md:py-12 flex flex-col gap-10">
          <div className="flex flex-col gap-2 text-center md:text-left">
            <h3 className="h3Text text-primary">Approved Classes & Flags</h3>
            <p className="bodyText text-thirdText">
              Recognised under international class societies and flag
              administrations.
            </p>
          </div>

          <div className="grid lg:grid-cols-2 gap-10">
            <div className="space-y-5">
              <h4 className="h4Text text-primary items-center">
                Approved Classes
              </h4>
              <div className="flex flex-wrap gap-3">
                {approvedClasses.map((item) => (
                  <div
                    key={item}
                    className="inline-flex items-center gap-2 rounded-full bg-secondary/10 border border-secondary/40 px-4 py-2"
                  >
                    <div className="size-8 rounded-full bg-primary flex items-center justify-center">
                      <span className="captionText text-secondaryText">
                        {item[0]}
                      </span>
                    </div>
                    <span className="h6Text text-primaryText">{item}</span>
                  </div>
                ))}
              </div>
            </div>

            {/* Flags */}
            <div className="space-y-5">
              <h4 className="h4Text text-primary">Flags</h4>
              <div className="flex flex-wrap gap-4">
                {flags.map((flag) => (
                  <div
                    key={flag}
                    className="flex flex-col items-center gap-3 rounded-2xl bg-secondary/10 border border-secondary/40 px-6 py-4 min-w-[140px]"
                  >
                    <div className="relative size-16 rounded-full overflow-hidden">
                      <Image
                        src="/images/flag-placeholder.jpg"
                        alt={flag}
                        fill
                        className="object-cover"
                      />
                    </div>
                    <span className="smallText text-primaryText text-center">
                      {flag}
                    </span>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </section>
      </section>
    </div>
  );
};
