"use client";

import { motion } from "framer-motion";
import Image from "next/image";
import { useState } from "react";

interface CountryCardProps {
  logo: string;
  image: string;
  name: string;
  link: string;
  index: number;
  isVisible?: boolean;
}

export const CountryCard = ({
  logo,
  image,
  name,
  index,
  link,
  isVisible = true,
}: CountryCardProps) => {
  const [isHovered, setIsHovered] = useState(false);

  return (
    <a
      href={link}
      target="_blank"
      className={
        index === 2
          ? "sm:col-span-2 xl:col-span-1 sm:justify-self-center xl:justify-self-auto"
          : ""
      }
    >
      <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={isVisible ? { opacity: 1, y: 0 } : {}}
        transition={{ duration: 0.5, delay: index * 0.1 }}
        onHoverStart={() => setIsHovered(true)}
        onHoverEnd={() => setIsHovered(false)}
        className="flex flex-col items-center"
      >
        <motion.div
          className="relative w-32 h-32 rounded-full overflow-hidden cursor-pointer"
          transition={{ duration: 0.3 }}
        >
          <Image src={image} alt={name} fill className="object-cover" />

          {/* Flag Overlay */}
          <motion.div
            initial={{ opacity: 0 }}
            animate={{ opacity: isHovered ? 1 : 0 }}
            transition={{ duration: 0.3 }}
            className="absolute inset-0 bg-black/40 flex items-center justify-center"
          >
            <motion.div
              initial={{ scale: 1, y: -60 }}
              animate={{
                scale: isHovered ? 1 : 1,
                y: isHovered ? 0 : -60,
              }}
              transition={{
                duration: 0.4,
                delay: 0.1,
                type: "spring",
                stiffness: 300,
                damping: 25,
              }}
              className="w-16 h-12 rounded overflow-hidden"
            >
              <Image
                src={logo}
                alt={`${name} flag`}
                width={64}
                height={48}
                className="object-contain w-full h-full"
              />
            </motion.div>
          </motion.div>
        </motion.div>

        <motion.h3
          initial={{ opacity: 0 }}
          animate={isVisible ? { opacity: 1 } : {}}
          transition={{ duration: 0.5, delay: index * 0.1 + 0.2 }}
          className="mt-4 bodyText text-primary font-medium text-center max-w-[20ch]"
        >
          {name}
        </motion.h3>
      </motion.div>
    </a>
  );
};
