// app/sitemap.ts

import type { MetadataRoute } from "next";
import servicesData from "@/data/services.json";

type SitemapEntry = {
  url: string;
  lastModified: Date;
  changeFrequency?:
    | "always"
    | "hourly"
    | "daily"
    | "weekly"
    | "monthly"
    | "yearly"
    | "never";
  priority?: number;
};

const BASE_URL = "";

const LOCALES = ["en", "ar"]; // Add more if needed

const services = servicesData?.services?.map((el) => `/services/${el?.slug}`);

const PATHS = ["/about", "/contact", "/fleet", "/services", ...services];

export default function sitemap(): MetadataRoute.Sitemap {
  const now = new Date();

  const routes = LOCALES?.flatMap((locale) => {
    return PATHS?.map((path) => {
      const url = `${BASE_URL}${locale}${path === "" ? "" : path}`;
      return {
        url,
        lastModified: now,
        changeFrequency: "weekly" as const,
        priority: path === "" ? 1 : path.startsWith("/services") ? 0.9 : 0.8,
      };
    });
  });

  return routes;
}
