// This file is generated automatically by Next.js
// Do not edit this file manually

type AppRoutes = "/[lang]" | "/[lang]/about" | "/[lang]/contact" | "/[lang]/fleet" | "/[lang]/services" | "/[lang]/services/[slug]"
type PageRoutes = never
type LayoutRoutes = "/" | "/[lang]"
type RedirectRoutes = never
type RewriteRoutes = never
type Routes = AppRoutes | PageRoutes | LayoutRoutes | RedirectRoutes | RewriteRoutes


interface ParamMap {
  "/": {}
  "/[lang]": { "lang": string; }
  "/[lang]/about": { "lang": string; }
  "/[lang]/contact": { "lang": string; }
  "/[lang]/fleet": { "lang": string; }
  "/[lang]/services": { "lang": string; }
  "/[lang]/services/[slug]": { "lang": string; "slug": string; }
}


export type ParamsOf<Route extends Routes> = ParamMap[Route]

interface LayoutSlotMap {
  "/": never
  "/[lang]": never
}


export type { AppRoutes, PageRoutes, LayoutRoutes, RedirectRoutes, RewriteRoutes, ParamMap }

declare global {
  /**
   * Props for Next.js App Router page components
   * @example
   * ```tsx
   * export default function Page(props: PageProps<'/blog/[slug]'>) {
   *   const { slug } = await props.params
   *   return <div>Blog post: {slug}</div>
   * }
   * ```
   */
  interface PageProps<AppRoute extends AppRoutes> {
    params: Promise<ParamMap[AppRoute]>
    searchParams: Promise<Record<string, string | string[] | undefined>>
  }

  /**
   * Props for Next.js App Router layout components
   * @example
   * ```tsx
   * export default function Layout(props: LayoutProps<'/dashboard'>) {
   *   return <div>{props.children}</div>
   * }
   * ```
   */
  type LayoutProps<LayoutRoute extends LayoutRoutes> = {
    params: Promise<ParamMap[LayoutRoute]>
    children: React.ReactNode
  } & {
    [K in LayoutSlotMap[LayoutRoute]]: React.ReactNode
  }
}
