import { cn } from "@/utils";
import { motion, AnimatePresence } from "framer-motion";
import { X } from "lucide-react";
import { useLocale } from "next-intl";
import { NavMenu } from "./Navitems";
import { socialLinks } from "./Navbar";
import Image from "next/image";
import { PrimaryButton } from "@/components";

interface SidebarProps {
  isOpen: boolean;
  onClose: () => void;
  menuData: any[];
}

export const Sidebar = ({ isOpen, onClose, menuData }: SidebarProps) => {
  const locale = useLocale();

  return (
    <>
      {/* Backdrop */}
      <AnimatePresence>
        {isOpen && (
          <motion.div
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            exit={{ opacity: 0 }}
            transition={{ duration: 0.2 }}
            className="fixed inset-0 bg-black/50 z-40 lg:hidden"
            onClick={onClose}
          />
        )}
      </AnimatePresence>

      {/* Sidebar */}
      <AnimatePresence>
        {isOpen && (
          <motion.div
            initial={{ x: locale === "ar" ? "100%" : "-100%" }}
            animate={{ x: 0 }}
            exit={{ x: locale === "ar" ? "100%" : "-100%" }}
            transition={{ type: "spring", damping: 25, stiffness: 200 }}
            className={cn(
              "fixed top-0 h-full w-11/12 sm:w-80 shadow-xl z-50 lg:hidden bg-white/30 backdrop-blur-lg",
              locale === "ar" ? "right-0" : "left-0"
            )}
          >
            <div className="flex flex-col h-full">
              {/* Header */}
              <div className="flex items-center justify-between p-4 border-b border-gray-200">
                <Image
                  src={"/images/logo-white.png"}
                  alt="logo"
                  width={75}
                  height={68}
                />
                <button onClick={onClose}>
                  <X className="size-5 cursor-pointer text-white" />
                </button>
              </div>

              {/* Content */}
              <div className="flex-1 overflow-y-auto p-4">
                {/* Dropdowns Section */}
                <NavMenu data={menuData} variant="mobile" locale={locale} />

                <div className="flex items-center flex-col-reverse gap-4 mt-4">
                  <div className="flex items-center gap-3">
                    {socialLinks?.map((link, index) => (
                      <a href={link?.href} key={index}>
                        <Image
                          src={link?.icon}
                          alt={link?.ariaLabel}
                          width={16}
                          height={16}
                        />
                      </a>
                    ))}
                  </div>

                  <PrimaryButton text="Book an Appointment" />
                </div>
              </div>
            </div>
          </motion.div>
        )}
      </AnimatePresence>
    </>
  );
};
