"use client";

import Image from "next/image";
import Link from "next/link";
import { motion } from "framer-motion";
import { PrimaryButton } from "@/components";

export type CTASectionProps = {
  title: string;
  description: string;
  buttonLabel?: string;
  buttonHref?: string;
  backgroundImage: string;
  imageAlt?: string;
};

export const CTASection = ({
  title,
  description,
  buttonLabel,
  buttonHref = "#",
  backgroundImage,
  imageAlt = "CTA background",
}: CTASectionProps) => {
  return (
    <motion.section
      className="p-4 md:p-6"
      initial={{ opacity: 0, y: 40 }}
      whileInView={{ opacity: 1, y: 0 }}
      viewport={{ once: true, amount: 0.35 }}
      transition={{ duration: 0.6, ease: "easeOut" }}
    >
      <div className="relative w-full min-h-130 flex flex-col justify-end rounded-4xl overflow-hidden">
        <Image
          src={backgroundImage}
          alt={imageAlt}
          fill
          priority
          quality={100}
          className="object-cover"
          sizes="(max-width: 768px) 100vw, 1200px"
        />

        <div className="relative z-10 flex h-full items-center px-6 py-10 md:px-12">
          <motion.div
            className="flex flex-col gap-4 max-w-2xl rounded-2xl bg-primary/70 backdrop-blur-xl p-6 md:p-9 pointer-events-auto"
            initial={{ opacity: 0, y: 30, scale: 0.95 }}
            animate={{ opacity: 1, y: 0, scale: 1 }}
            transition={{
              duration: 0.7,
              ease: [0.25, 0.46, 0.45, 0.94],
            }}
          >
            <div className="overflow-hidden">
              <motion.h2
                className="h5Text text-secondaryText max-w-[20ch]"
                initial={{ opacity: 0, y: 15 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.7, delay: 0.1, ease: "easeInOut" }}
              >
                {title}
              </motion.h2>
            </div>

            <div className="overflow-hidden">
              <motion.p
                className="bodyText text-secondaryText/90 max-w-[30ch]"
                initial={{ opacity: 0, y: 12 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.7, delay: 0.2, ease: "easeInOut" }}
              >
                {description}
              </motion.p>
            </div>

            {buttonLabel && (
              <Link href={buttonHref} className="pt-2" aria-label={buttonLabel}>
                <PrimaryButton text={buttonLabel} />
              </Link>
            )}
          </motion.div>
        </div>
      </div>
    </motion.section>
  );
};
