import axios, { AxiosRequestConfig } from "axios";
import { getCookie } from "cookies-next/client";

interface CustomAxiosRequestConfig<TData> extends AxiosRequestConfig<TData> {
  withToken?: boolean;
  lang?: string;
  geoParams?: boolean;
}

const apiUrl = process.env.NEXT_PUBLIC_API_URL;
const client = axios.create({ baseURL: apiUrl });

export const request = async <TResponse = any, TData = any>({
  withToken = false,
  lang,
  geoParams = false,
  ...options
}: CustomAxiosRequestConfig<TData>): Promise<TResponse> => {
  const language = getCookie("NEXT_LOCALE");

  client.defaults.headers.common["accept-language"] = language;

  //   if (withToken) {
  //     const token = getCookie(StaticKey.ACCESS_TOKEN) || null;

  //     if (token) {
  //       client.defaults.headers.common.Authorization = `Bearer ${token}`;
  //     }
  //   }

  return client({ ...options }).then((data) => data.data);
};
