export type TPageSizeOption = 5 | 10 | 20 | 50 | 100 | 200;

export type TPaginationModel = {
  with_paginate?: "yes" | "no";
  page?: number;
  per_page?: TPageSizeOption;
};

export type TSearch = {
  id?: number;
  sort_as?: "asc" | "desc";
  sort_by?: string;
  search?: string;
  user_id?: number;
};

interface IPaginateLink {
  url: string | null;
  label: string;
  active: boolean;
}

export interface IPaginatedData<TData = any> {
  current_page: number;
  data: TData;
  first_page_url: string;
  from: number;
  last_page: number;
  last_page_url: string;
  links: IPaginateLink[];
  next_page_url: string | null;
  path: string;
  per_page: number;
  prev_page_url: string | null;
  to: number;
  total: number;
}
