"use client";
import { useEffect, useState } from "react";
import { useTheme } from "next-themes";
import { Moon, Sun } from "lucide-react";
import { cn } from "@/utils";

export const ThemeSwitcher = () => {
  const { setTheme, resolvedTheme } = useTheme();
  const [mounted, setMounted] = useState(false);

  useEffect(() => setMounted(true), []);
  if (!mounted) {
    // optional: a neutral placeholder to avoid layout shift
    return (
      <div className="relative size-11 rounded-full border flex items-center justify-center" />
    );
  }

  const isLight = resolvedTheme === "light";

  return (
    <button
      type="button"
      aria-label={`Switch to ${isLight ? "dark" : "light"} mode`}
      onClick={() => setTheme(isLight ? "dark" : "light")}
      className="relative size-11 rounded-full flex items-center justify-center border transition-colors duration-300 cursor-pointer"
    >
      {isLight ? (
        <Sun
          className={cn(
            "absolute size-5 md:size-6 text-primary transition-all duration-500",
            "rotate-0 scale-100 opacity-100"
          )}
        />
      ) : (
        <Moon
          className={cn(
            "absolute size-5 md:size-6 transition-all duration-500",
            "text-white rotate-0 scale-100 opacity-100"
          )}
        />
      )}
    </button>
  );
};
