import { cn } from "@/utils";
import { CheckCircle } from "lucide-react";

export const ItemWithCheck = ({ title }: { title: string }) => {
  return (
    <div className="flex items-start gap-2.5 w-fit">
      <CheckCircle
        className={cn(
          "size-5 min-w-5 min-h-5 sm:size-6 sm:min-w-6 sm:min-h-6 text-primary"
        )}
      />
      <p className={cn("h6Text text-primary")}>{title}</p>
    </div>
  );
};
