import Link from "next/link";
import Image from "next/image";
import { headers } from "next/headers";

export default async function NotFound() {
  const accept = (await headers()).get("accept-language")?.toLowerCase() || "";
  const isAr = accept.includes("ar");

  const title = isAr ? "الصفحة غير موجودة" : "Page not found";
  const message = isAr
    ? "الصفحة التي تبحث عنها غير موجودة أو تم نقلها."
    : "The page you're looking for doesn't exist or was moved.";
  const goHome = isAr ? "الصفحة الرئيسية" : "Go Home";

  return (
    <section className="custom-container py-10 md:py-16">
      <div className="flex flex-col md:flex-row items-center justify-between gap-8 md:gap-16">
        <div className="w-full md:w-1/2 text-center md:text-start">
          <h1 className="h3Text text-primary">{title}</h1>
          <p className="bodyText text-thirdText mt-3">{message}</p>
          <div className="mt-6 flex items-center gap-3 justify-center md:justify-start">
            <Link
              href="/"
              className="px-5 py-3 rounded-xl bg-primary text-white hover:brightness-95 transition"
            >
              {goHome}
            </Link>
          </div>
        </div>
        <div className="w-full md:w-1/2">
          <Image
            src="/images/default.png"
            alt={title}
            width={460}
            height={460}
            className="w-full rounded-3xl aspect-square object-cover"
            priority
          />
        </div>
      </div>
    </section>
  );
}
